/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.pdraw.standard;

import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.standard.FigureEnumerator;
import DE.siemens.ad.logo.app.Editor;
import DE.siemens.ad.logo.app.action.ActionManager;
import DE.siemens.ad.logo.app.comp.HideableToolBar;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.BlockGroup;
import DE.siemens.ad.logo.model.WiringDiagram;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.pdraw.action.InsertBlockAction;
import DE.siemens.ad.pdraw.action.SubstituteBlockAction;
import DE.siemens.ad.pdraw.app.LogoComfort;
import DE.siemens.ad.pdraw.app.LogoHelp;
import DE.siemens.ad.pdraw.figures.BlockConnectorOwner;
import DE.siemens.ad.pdraw.figures.BlockFigure;
import DE.siemens.ad.pdraw.figures.FixedElbowConnection;
import DE.siemens.ad.pdraw.figures.PageLineFigure;
import DE.siemens.ad.pdraw.standard.BlockConnectionTool;
import DE.siemens.ad.pdraw.standard.LogoAbstractTool;
import DE.siemens.ad.pdraw.standard.LogoDrawing;
import DE.siemens.ad.pdraw.standard.LogoDrawingView;
import DE.siemens.ad.pdraw.standard.LogoGridConstrainer;
import DE.siemens.ad.pdraw.standard.LogoSelectionTool;
import DE.siemens.ad.pdraw.standard.MouseInteractor;
import DE.siemens.ad.pdraw.standard.UsedResourcesChangedListener;
import DE.siemens.ad.pdraw.util.BlockJButton;
import DE.siemens.ad.udf.EditUDFFigure;
import DE.siemens.ad.udf.LogoDrawingUDF;
import DE.siemens.ad.udf.LogoDrawingViewUDF;
import DE.siemens.ad.udf.UDFBlock;
import DE.siemens.ad.udf.UDFBlockFigure;
import DE.siemens.ad.udf.UDFFactory;
import DE.siemens.ad.udf.UDFLeftConnectorFigure;
import DE.siemens.ad.udf.UDFRightConnectorFigure;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import javax.help.CSH;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JOptionPane;

public class ImageBlockTool
extends LogoAbstractTool
implements UsedResourcesChangedListener {
    private boolean fActiveTool;
    protected String fClassName;
    protected boolean fIsUDFBlock;
    protected String fFilePath = null;
    protected BlockGroup fBlockGroup;
    private HideableToolBar fBlockToolBar;
    private ButtonGroup fBlockButtonGroup;
    protected MouseInteractor fInteractor;
    protected BlockConnectionTool fConnectionInteractor = new BlockConnectionTool(new FixedElbowConnection());
    private BlockButtonActionListener fBlockButtonActionListener;

    public ImageBlockTool() {
        this.fCursorName = "BlockToolCursor";
        this.fBlockButtonGroup = new ButtonGroup();
    }

    public HideableToolBar getBlockToolBar() {
        if (this.fBlockToolBar == null) {
            this.fBlockToolBar = new HideableToolBar();
        }
        return this.fBlockToolBar;
    }

    public ImageBlockTool(BlockGroup blockGroup) {
        this.fCursorName = "BlockToolCursor";
        this.fBlockGroup = blockGroup;
        this.fBlockToolBar = new HideableToolBar();
        this.fBlockToolBar.setTitle(Language.getString("toolbar.title.block", "Blocks"));
        this.fBlockToolBar.setVisible(false);
        CSH.setHelpIDString((Component)this.fBlockToolBar, (String)"toolbar.blocks");
        this.fBlockButtonGroup = new ButtonGroup();
        this.addBlocks(blockGroup, this.fBlockButtonGroup, this.fBlockToolBar);
    }

    protected void selectFirstBlockButton() {
        Enumeration<AbstractButton> blockButtons = this.fBlockButtonGroup.getElements();
        if (blockButtons.hasMoreElements()) {
            ((BlockJButton)blockButtons.nextElement()).doClick();
        }
    }

    private boolean addBlocks(BlockGroup blockGroup, ButtonGroup buttonGroup, HideableToolBar blockToolBar) {
        boolean blocksInserted = false;
        Object previousElement = null;
        boolean previousBlocksInserted = false;
        for (Object element : blockGroup.getBlocks()) {
            if (element instanceof BlockGroup) {
                if (previousElement instanceof BlockGroup && previousBlocksInserted && ((BlockGroup)element).getBlockGroupVisible().booleanValue()) {
                    blockToolBar.addSeparator();
                }
                previousBlocksInserted = this.addBlocks((BlockGroup)element, buttonGroup, blockToolBar);
            } else {
                previousBlocksInserted = this.addBlock((Block)element, buttonGroup, blockToolBar);
            }
            blocksInserted = blocksInserted || previousBlocksInserted;
            previousElement = element;
        }
        return blocksInserted;
    }

    private boolean addBlock(Block block, ButtonGroup buttonGroup, HideableToolBar blockToolBar) {
        BlockJButton blockButton = this.createBlockJButton(block);
        if (blockButton != null) {
            buttonGroup.add(blockButton);
            String helpID = block.getLanguageKey();
            CSH.setHelpIDString((Component)blockButton, (String)helpID);
            LogoHelp.enableHelpOnButton(blockButton, helpID);
            blockToolBar.add(blockButton);
            blockButton.addActionListener(this.getBlockButtonActionListener());
            return true;
        }
        return false;
    }

    private BlockButtonActionListener getBlockButtonActionListener() {
        if (this.fBlockButtonActionListener == null) {
            this.fBlockButtonActionListener = new BlockButtonActionListener();
        }
        return this.fBlockButtonActionListener;
    }

    protected void blockButtonPressed(BlockJButton blockJButton) {
        this.setClassName(blockJButton.getBlock());
    }

    public void activate(DrawingView view) {
        super.activate(view);
        this.setActiveTool(true);
        view.setCursor(this.getCursor());
        this.setComponentInApplication(view);
        this.checkBlockAvailability(((LogoDrawing)view.drawing()).getWiringDiagram());
        ((LogoDrawing)view.drawing()).getWiringDiagram().addUsedResourcesChangedListener(this);
        if (this.fBlockButtonGroup.getSelection() == null) {
            this.selectFirstBlockButton();
        }
    }

    protected void setComponentInApplication(DrawingView view) {
        JComponent c = ((LogoComfort)view.editor()).getApplicationSurface().getWindowManager().getToolbarPanel("Block", "South");
        c.add(this.fBlockToolBar);
    }

    public void checkBlockAvailability(WiringDiagram wiringDiagram) {
        Enumeration<AbstractButton> blockButtons = this.fBlockButtonGroup.getElements();
        while (blockButtons.hasMoreElements()) {
            BlockJButton blockButton = (BlockJButton)blockButtons.nextElement();
            blockButton.setEnabled(blockButton.getBlock().isResourceAvailable(wiringDiagram));
        }
    }

    protected BlockJButton createBlockJButton(Block block) {
        return new BlockJButton(block);
    }

    public void deactivate(DrawingView view) {
        if (this.fBlockToolBar != null) {
            this.fBlockToolBar.setVisible(false);
        }
        this.setActiveTool(false);
        ((LogoDrawing)view.drawing()).getWiringDiagram().removeUsedResourcesChangedListener(this);
    }

    protected String getInsertActionString() {
        return "InsertBlockAction";
    }

    protected boolean isInsertable(MouseEvent evt, int x, int y, DrawingView view) {
        return this.fBlockButtonGroup.getSelection().isEnabled();
    }

    public void mouseDown(MouseEvent e, int x, int y, DrawingView view) {
        if (this.fClassName == null) {
            return;
        }
        if (!(view.getConstrainer() instanceof LogoGridConstrainer) || ((LogoGridConstrainer)view.getConstrainer()).getStepX() < 40) {
            x -= 12;
            y -= 15;
        }
        Figure insideFigure = view.drawing().findFigureInside(e.getX(), e.getY());
        if (insideFigure != null && (insideFigure instanceof BlockConnectorOwner || insideFigure instanceof UDFLeftConnectorFigure || insideFigure instanceof UDFRightConnectorFigure)) {
            this.fInteractor = this.fConnectionInteractor;
            this.fInteractor.mouseDown(e, x, y, view);
            return;
        }
        if (this.testInputArea(x, y, view)) {
            Figure figure = view.drawing().findFigure(e.getX(), e.getY());
            if (figure instanceof BlockFigure) {
                this.fInteractor = new LogoSelectionTool();
                this.fInteractor.mouseDown(e, x, y, view);
                return;
            }
            if (e.getClickCount() == 2) {
                this.handleDoubleClicked(e, view);
            }
            return;
        }
        if (this.isInsertable(e, x, y, view)) {
            try {
                LogoDrawing drawing = (LogoDrawing)view.drawing();
                WiringDiagram wDiagram = drawing.getWiringDiagram();
                Block block = null;
                block = !this.fIsUDFBlock ? Block.createInstanceForName(this.fClassName, wDiagram) : UDFFactory.instance().getUDFBlock(wDiagram, this.fFilePath, false);
                ActionManager actionManager = ((Editor)((Object)view.editor())).getActionManager();
                InsertBlockAction insertAction = (InsertBlockAction)actionManager.getActionFactory().getAction(this.getInsertActionString());
                BlockFigure insertedFigure = this.getBlockFigure(block, new Point(x, y));
                if (view.getConstrainer() != null) {
                    insertedFigure.moveAlignmentAnchorTo(new Point(x, y));
                }
                insertAction.setBlockFigure(insertedFigure);
                actionManager.invokeAction(insertAction);
            }
            catch (IOException io) {
                io.printStackTrace();
            }
        }
    }

    protected BlockFigure getBlockFigure(Block block, Point p) {
        if (block instanceof UDFBlock) {
            return new UDFBlockFigure((UDFBlock)block, p);
        }
        return new BlockFigure(block, p);
    }

    public void mouseUp(MouseEvent e, int x, int y, DrawingView view) {
        if (!e.isPopupTrigger()) {
            view.clearSelection();
        }
        if (this.fInteractor != null) {
            this.fInteractor.mouseUp(e, x, y, view);
            this.fInteractor = null;
            return;
        }
        if (this.testInputArea(x, y, view)) {
            view.setCursor(Cursor.getDefaultCursor());
        } else {
            this.setCursor(this.fCursor);
        }
    }

    protected void replaceFigure(int x, int y, DrawingView view) {
        Figure f = view.drawing().findFigure(x, y);
        if (!(f instanceof BlockFigure)) {
            return;
        }
        int rw = JOptionPane.showConfirmDialog((Component)((Object)view), "An der angegebenen Position befindet sich bereits ein Block.\nSoll dieser Block ersetzt werden?", "Block ersetzen?", 0);
        if (rw != 0) {
            return;
        }
        LogoDrawing drawing = (LogoDrawing)view.drawing();
        WiringDiagram wDiagram = drawing.getWiringDiagram();
        Block newBlock = null;
        try {
            newBlock = Block.createInstanceForName(this.fClassName, wDiagram);
        }
        catch (Exception e) {
            return;
        }
        SubstituteBlockAction substitueBlockAction = new SubstituteBlockAction();
        substitueBlockAction.setOwner((Editor)((Object)view.editor()));
        substitueBlockAction.setOldBlockFigure((BlockFigure)f);
        substitueBlockAction.setNewBlock(newBlock);
        ((LogoComfort)view.editor()).getActionManager().invokeAction(substitueBlockAction);
    }

    public void setClassName(Block blk) {
        this.fClassName = blk.getClassName();
        if (blk instanceof UDFBlock) {
            this.fIsUDFBlock = true;
            this.fFilePath = ((UDFBlock)blk).getUDFFilePath();
        } else {
            this.fIsUDFBlock = false;
            this.fFilePath = null;
        }
    }

    protected boolean testInputArea(int x, int y, DrawingView view) {
        if (((LogoDrawingView)view).getConstrainer() instanceof LogoGridConstrainer) {
            Point constraintPoint = ((LogoGridConstrainer)((LogoDrawingView)view).getConstrainer()).constrainPoint(new Point(x, y));
            x = constraintPoint.x;
            y = constraintPoint.y;
        }
        boolean retValue = false;
        int imageWidth = 24;
        int imageHeight = 33;
        Vector intersected = ((LogoDrawing)view.drawing()).getFiguresIntersectRectangle(new Rectangle(x, y, imageWidth, imageHeight));
        FigureEnumerator fEnum = new FigureEnumerator(intersected);
        int ignoreFigureCounter = 0;
        while (fEnum.hasMoreElements()) {
            Figure f = fEnum.nextFigure();
            if (!(f instanceof FixedElbowConnection) && !(f instanceof PageLineFigure) && !(f instanceof EditUDFFigure)) continue;
            ++ignoreFigureCounter;
        }
        if (intersected.size() > ignoreFigureCounter) {
            retValue = true;
        } else if (view.drawing() instanceof LogoDrawingUDF) {
            retValue = !((LogoDrawingViewUDF)view).canHoldFiugre(new Point(x, y));
        }
        return retValue;
    }

    public void usedResourcesChanged(WiringDiagram wiringDiagram) {
        this.checkBlockAvailability(wiringDiagram);
    }

    public void mouseMove(MouseEvent evt, int x, int y, DrawingView view) {
        super.mouseMove(evt, x, y, view);
        if (this.testInputArea(x, y, view)) {
            view.setCursor(Cursor.getDefaultCursor());
        } else {
            view.setCursor(this.fCursor);
        }
        this.fConnectionInteractor.mouseMove(evt, x, y, view);
    }

    public void mouseDrag(MouseEvent e, int x, int y, DrawingView view) {
        if (this.fInteractor != null) {
            this.fInteractor.mouseDrag(e, x, y, view);
        }
    }

    protected boolean isActiveTool() {
        return this.fActiveTool;
    }

    public void editorActivated(Editor editor) {
        super.editorActivated(editor);
        if (this.fBlockToolBar != null) {
            this.fBlockToolBar.setVisible(true);
        }
    }

    public void editorDeactivated(Editor editor) {
        super.editorActivated(editor);
        if (this.fBlockToolBar != null) {
            this.fBlockToolBar.setVisible(false);
        }
    }

    protected void setActiveTool(boolean activeTool) {
        this.fActiveTool = activeTool;
    }

    protected class BlockButtonActionListener
    implements ActionListener {
        protected BlockButtonActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            ImageBlockTool.this.blockButtonPressed((BlockJButton)e.getSource());
        }
    }
}

